#include <Windows.h>

#include <Shlwapi.h>
#pragma comment(lib,"shlwapi")

#include "./pxtone.h"

static HWND _hWnd        = NULL;
static char *_class_name = "testwindow";

static LRESULT CALLBACK _Procedure( HWND hWnd, UINT msg, WPARAM w, LPARAM l )
{
	switch( msg )
	{
	case WM_CREATE:

		break;

	case WM_CLOSE:
		DestroyWindow( hWnd );
		PostQuitMessage( 0 );
		break;


	default:
		return DefWindowProc( hWnd, msg, w, l );
	}

    return 0;
}


int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrev, LPSTR pCmd, int nCmd )
{

	{
		WNDCLASSEX wc;

		memset( &wc, 0, sizeof(WNDCLASSEX) );

		wc.cbSize        = sizeof(WNDCLASSEX);
		wc.lpszClassName = _class_name;
		wc.style         = CS_HREDRAW | CS_VREDRAW;
		wc.lpfnWndProc   = _Procedure;
		wc.hInstance     = hInst;       
		wc.hbrBackground = (HBRUSH)(COLOR_APPWORKSPACE + 1);
		wc.hIcon         = LoadIcon( hInst, "0" );
		wc.hCursor       = LoadCursor( NULL, IDC_ARROW );

		if( !RegisterClassEx( &wc ) ) return FALSE;
	}


	// EChE𐶐
	_hWnd  = CreateWindow(
		_class_name,
		"testPxtone",
		WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_CLIPCHILDREN,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		320, 240,
		HWND_DESKTOP,
		NULL,
		hInst,
		NULL );

	if( !pxtone_Ready(
		_hWnd,          // EChEnhnĂ
		2,   // ̃`lw肵ĂB( 1:m / 2:XeI )
		44100,           // bԃTvO[głB      ( 11025 / 22050 / 44100 )
		16,           // PTv\rbgłB( 8 / 16 )
		0.1f,   // ȂĐ̂Ɏgpobt@TCYbŎw肵܂B(  0.1 )
		TRUE,  // TRUE: DirectSound gp܂ / FALSE: WAVEMAPPER gp܂B
		NULL // TvOɌĂ΂֐łBNULL ł܂܂B
	         ) // pxtone ̏
	)
	{
		MessageBox( NULL, "ready pxtone", "err", 0 );
		return 1;
	}

	ShowWindow( _hWnd, SW_SHOW );

	{
		char path_src[ MAX_PATH ];

		GetModuleFileName( NULL, path_src, MAX_PATH );
		PathRemoveFileSpec( path_src );
		strcat( path_src, "\\opening.ptcop" );

		if( !pxtone_Tune_Load(
			NULL,       // \[Xǂޏꍇ̓W[nhw肵܂BNULL łȂB
			NULL, // \[Xǂޏꍇ̓\[X̎ޖBOt@Cǂޏꍇ NULLB
			path_src  // t@CpX̓\[XB
			) )
		{
			MessageBox( NULL, "load data", "err", 0 );
			return 1;
		}
	}


	if( !pxtone_Tune_Start(
		0,     // JnʒułB Stop  Fadeout Ŏ擾lݒ肵܂B0 ōŏB
		0       // tF[hCꍇ͂Ɏԁi~bjw肵܂B
		) )
	{
		MessageBox( NULL, "start", "err", 0 );
		return 1;
	}


	MSG msg;
	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		TranslateMessage( &msg );
		DispatchMessage(  &msg );
	}

	pxtone_Tune_Fadeout( 1000 );

	while( pxtone_Tune_IsStreaming() )
	{
		Sleep( 100 );
	}

	return 1;
}
